# ELEMENTS E384COMMLIB FOR eNPR 10MHz DEVICE - PROGRAMMING EXAMPLE
## BRIEF DESCRIPTION
This project briefly illustrates how to use fundamental functions offered by the E384COMMLIB to develop your applications for the ELEMENTS SRL eNPR 10MHz device. The main.cpp example shows
- how to detect the device
- how to connect to the device
- how to check the voltage/current channel numbers
- how to check the available current ranges and sampling rates and how to set the desired values
- how to use the digital offset compensation
- how to check the voltage stimulus protocol offered by the device
- how to choose a protocol, set its parameters and apply it to the device.
- a few illustrative error codes returned commonly
The protocol results (voltage and current traces) are saved to file.
## REQUIREMENTS
Currently supported platforms:
- Windows 10+
### DRIVERS
Install EMCR to make sure all the needed drivers are correctly installed [elements-ic.com/downloads/](https://elements-ic.com/downloads/)
### WINDOWS
- ftd2xx.dll: additional third party library (developed and released by FTDI [www.ftdichip.com](https://www.ftdichip.com))
- okFrontPanel.dll, okimpl_fpoip.dll: additional third party libraries (developed and released by Opal Kelly [www.opalkelly.com](https://www.opalkelly.com))
## CONTENT OF THIS ARCHIVE
- readme.md: this readme file
- LICENSE: the license we chose
- main.cpp: a short coding example exploiting the e384commlib
- include folder: which includes all the headers for the e384commlib
- libs\e384commlib folder: which includes the dynamically and statically built e384commlib
- libs\dependencies folder: which includes the third party libraries
- scripts\plotData.m: a Matlab script to plot the voltage and current traces saved to file by main.cpp when applying a protocol
### BUILDING THE LIBRARY YOURSELF
The e384commlib source code is available on github [github.com/Elements-SRL/e384commLib](https://github.com/Elements-SRL/e384commLib/)
## HOW TO COMPILE THIS EXAMPLE
main.cpp can be compiled using visual studio 2017 or newer 64bit
- unzip this archive in a folder of your choice (hereafter FOLDER)
- check you have Visual Studio installed (the Community release can be used for free)
- add libs\e384commlib\dynamic and libs\dependencies to windows PATH
- add include and all its subfolders to the additional include directories
- add libs\e384commlib\dynamic to the additional libraries directories
- add e384commlib.lib to the additional dependencies
## HOW TO RUN THIS EXAMPLE
- connect the eNPR 10MHz device to your PC
- run the main.exe executable produced by the previous compilation steps
- a new myLog.dat file will be saved in folder
- visualize the results using the Matlab script plotData.m or write your own visualization script e.g. in Python
- the data is saved in file myLog.dat with the following configuration:
	- current range 100nA
	- sampling rate 1.25MHz
	- model cell 	10MOhm // 2.5pF
	- protocol time 10s
	- protocol		square wave
		- holding voltage 	0mV for 100ms
		- positive pulse	100mV for 100ms
		- negative pulse	-100mV for 100ms